<?php
// === Conexão com o banco (PDO) ===
$host = "localhost";
$user = "kaltekgo_admin";       
$pass = "kaltek@2024";          
$db   = "kaltekgo_avila";       

try {
    $pdo = new PDO("mysql:host=$host;dbname=$db;charset=utf8", $user, $pass);
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
} catch (PDOException $e) {
    die("Erro de conexão: " . $e->getMessage());
}

// === Consulta com JOIN, contagens e cálculos === Educação Infantil Matutino
$sqledim = "SELECT 
    v.sala_matriz,
    v.turma_nome AS turma,
    v.vagas_fisicas,
    v.ano_2025 AS ano_anterior,
    v.id,

    -- Conta todos os registros da turma
    COUNT(c.turma) AS matriculados,

    -- Conta só onde veterano = 1
    SUM(CASE WHEN c.veterano = 1 THEN 1 ELSE 0 END) AS veteranos,

    -- Conta só onde calouro = 1
    SUM(CASE WHEN c.calouro = 1 THEN 1 ELSE 0 END) AS novatos,

    -- Calcula vagas restantes e vagas reais
    (v.vagas_fisicas - COUNT(c.turma)) AS vagas_restantes,
    (v.ano_2025 - SUM(CASE WHEN c.veterano = 1 THEN 1 ELSE 0 END)) AS vagas_reais

FROM vagas_series_turmas v
LEFT JOIN calouros_veteranos c 
       ON v.turma_nome = c.turma
WHERE v.turma_nome LIKE 'INFANTIL%' AND turno = 'matutino'
GROUP BY v.sala_matriz, v.turma_nome, v.vagas_fisicas, v.ano_2025, v.id
ORDER BY v.id ASC;

";

$stmt = $pdo->prepare($sqledim);
$stmt->execute();
$dadosedim = $stmt->fetchAll(PDO::FETCH_ASSOC);

// === Consulta com JOIN, contagens e cálculos === Educação infantil Vespertino
$sqlediv = "SELECT 
    v.sala_matriz,
    v.turma_nome AS turma,
    v.vagas_fisicas,
    v.ano_2025 AS ano_anterior,
    v.id,

    -- Conta todos os registros da turma
    COUNT(c.turma) AS matriculados,

    -- Conta só onde veterano = 1
    SUM(CASE WHEN c.veterano = 1 THEN 1 ELSE 0 END) AS veteranos,

    -- Conta só onde calouro = 1
    SUM(CASE WHEN c.calouro = 1 THEN 1 ELSE 0 END) AS novatos,

    -- Calcula vagas restantes e vagas reais
    (v.vagas_fisicas - COUNT(c.turma)) AS vagas_restantes,
    (v.ano_2025 - SUM(CASE WHEN c.veterano = 1 THEN 1 ELSE 0 END)) AS vagas_reais

FROM vagas_series_turmas v
LEFT JOIN calouros_veteranos c 
       ON v.turma_nome = c.turma
WHERE v.turma_nome LIKE 'INFANTIL%' AND turno = 'vespertino'
GROUP BY v.sala_matriz, v.turma_nome, v.vagas_fisicas, v.ano_2025, v.id
ORDER BY v.id ASC;

";

$stmt = $pdo->prepare($sqlediv);
$stmt->execute();
$dadosediv = $stmt->fetchAll(PDO::FETCH_ASSOC);

// === Consulta com JOIN, contagens e cálculos === Fundamental 1 - Matutino
$sqlf1m = "SELECT 
    v.sala_matriz,
    v.turma_nome AS turma,
    v.vagas_fisicas,
    v.ano_2025 AS ano_anterior,
    v.id,

    -- Conta todos os registros da turma
    COUNT(c.turma) AS matriculados,

    -- Conta só onde veterano = 1
    SUM(CASE WHEN c.veterano = 1 THEN 1 ELSE 0 END) AS veteranos,

    -- Conta só onde calouro = 1
    SUM(CASE WHEN c.calouro = 1 THEN 1 ELSE 0 END) AS novatos,

    -- Calcula vagas restantes e vagas reais
    (v.vagas_fisicas - COUNT(c.turma)) AS vagas_restantes,
    (v.ano_2025 - SUM(CASE WHEN c.veterano = 1 THEN 1 ELSE 0 END)) AS vagas_reais

FROM vagas_series_turmas v
LEFT JOIN calouros_veteranos c 
       ON v.turma_nome = c.turma
WHERE v.id  BETWEEN 11 AND 27
GROUP BY v.sala_matriz, v.turma_nome, v.vagas_fisicas, v.ano_2025, v.id
ORDER BY v.id ASC;

";

$stmt = $pdo->prepare($sqlf1m);
$stmt->execute();
$dadosf1m = $stmt->fetchAll(PDO::FETCH_ASSOC);


// === Consulta com JOIN, contagens e cálculos === Fundamental 1 - Vespertino
$sqlf1v = "SELECT 
    v.sala_matriz,
    v.turma_nome AS turma,
    v.vagas_fisicas,
    v.ano_2025 AS ano_anterior,
    v.id,

    -- Conta todos os registros da turma
    COUNT(c.turma) AS matriculados,

    -- Conta só onde veterano = 1
    SUM(CASE WHEN c.veterano = 1 THEN 1 ELSE 0 END) AS veteranos,

    -- Conta só onde calouro = 1
    SUM(CASE WHEN c.calouro = 1 THEN 1 ELSE 0 END) AS novatos,

    -- Calcula vagas restantes e vagas reais
    (v.vagas_fisicas - COUNT(c.turma)) AS vagas_restantes,
    (v.ano_2025 - SUM(CASE WHEN c.veterano = 1 THEN 1 ELSE 0 END)) AS vagas_reais

FROM vagas_series_turmas v
LEFT JOIN calouros_veteranos c 
       ON v.turma_nome = c.turma
WHERE v.turma_nome LIKE '%ANO%' AND turno = 'vespertino'
GROUP BY v.sala_matriz, v.turma_nome, v.vagas_fisicas, v.ano_2025, v.id
ORDER BY v.id ASC;

";

$stmt = $pdo->prepare($sqlf1v);
$stmt->execute();
$dadosf1v = $stmt->fetchAll(PDO::FETCH_ASSOC);

// === Consulta com JOIN, contagens e cálculos === Fundamental 2 - Matutino
$sqlf2m = "SELECT 
    v.sala_matriz,
    v.turma_nome AS turma,
    v.vagas_fisicas,
    v.ano_2025 AS ano_anterior,
    v.id,

    -- Conta todos os registros da turma
    COUNT(c.turma) AS matriculados,

    -- Conta só onde veterano = 1
    SUM(CASE WHEN c.veterano = 1 THEN 1 ELSE 0 END) AS veteranos,

    -- Conta só onde calouro = 1
    SUM(CASE WHEN c.calouro = 1 THEN 1 ELSE 0 END) AS novatos,

    -- Calcula vagas restantes e vagas reais
    (v.vagas_fisicas - COUNT(c.turma)) AS vagas_restantes,
    (v.ano_2025 - SUM(CASE WHEN c.veterano = 1 THEN 1 ELSE 0 END)) AS vagas_reais

FROM vagas_series_turmas v
LEFT JOIN calouros_veteranos c 
       ON v.turma_nome = c.turma
WHERE (
    v.turma_nome LIKE '%6º%' OR
    v.turma_nome LIKE '%7º%' OR
    v.turma_nome LIKE '%8º%' OR
    v.turma_nome LIKE '%9º%'
) AND turno = 'matutino'
GROUP BY v.sala_matriz, v.turma_nome, v.vagas_fisicas, v.ano_2025, v.id
ORDER BY v.id ASC;
";

$stmt = $pdo->prepare($sqlf2m);
$stmt->execute();
$dadosf2m = $stmt->fetchAll(PDO::FETCH_ASSOC);

// === Consulta com JOIN, contagens e cálculos === Ensino medio - Matutino
$sqlem = "SELECT 
    v.sala_matriz,
    v.turma_nome AS turma,
    v.vagas_fisicas,
    v.ano_2025 AS ano_anterior,
    v.id,

    -- Conta todos os registros da turma
    COUNT(c.turma) AS matriculados,

    -- Conta só onde veterano = 1
    SUM(CASE WHEN c.veterano = 1 THEN 1 ELSE 0 END) AS veteranos,

    -- Conta só onde calouro = 1
    SUM(CASE WHEN c.calouro = 1 THEN 1 ELSE 0 END) AS novatos,

    -- Calcula vagas restantes e vagas reais
    (v.vagas_fisicas - COUNT(c.turma)) AS vagas_restantes,
    (v.ano_2025 - SUM(CASE WHEN c.veterano = 1 THEN 1 ELSE 0 END)) AS vagas_reais

FROM vagas_series_turmas v
LEFT JOIN calouros_veteranos c 
       ON v.turma_nome = c.turma
WHERE (
    v.turma_nome LIKE '%1º ANO - M (2026)%' OR
    v.turma_nome LIKE '%2º ANO - M (2026)%'
) AND turno = 'matutino'
GROUP BY v.sala_matriz, v.turma_nome, v.vagas_fisicas, v.ano_2025, v.id
ORDER BY v.id ASC;
";

$stmt = $pdo->prepare($sqlem);
$stmt->execute();
$dadosem = $stmt->fetchAll(PDO::FETCH_ASSOC);
?>

<!DOCTYPE html>
<html lang="pt-br">
<head>
  <meta name="viewport" content="width=device-width, initial-scale=1"> <!-- importante para mobile -->
  <meta charset="UTF-8">
  <title>Relat&oacute;rio de alunos matriculados</title>
  <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/3.4.1/css/bootstrap.min.css">
  <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
  <style>
    body {
      font-family: Arial, sans-serif;
      background-color: #ffffff;
      margin: 20px;
      color: #000000;
    }

    .container-fluid {
      width: 100%;
    }

    h4, h5 {
      margin: 0 0 10px;
    }

    table {
      white-space: nowrap;
      width: 100%;
      border-collapse: collapse;
      background-color: #ffffff;
      box-shadow: 0 0 10px rgba(0,0,0,0.1);
      text-transform: uppercase;
      min-width: auto;
    }

    th, td {
      padding: 12px 15px;
      text-align: left;
      font-size: 12px;
      border: 1px solid #000;
      vertical-align: middle !important;
    }

    th {
      background-color: #000;
      color: #fff;
    }

    tr:nth-child(even) {
      background-color: #f4f4f4;
    }

    tr:hover {
      background-color: #e0e0e0;
    }
    
    .table-container {
      max-height: 350px;   /* altura fixa */
      overflow-y: auto;    /* rolagem vertical */
      overflow-x: hidden;  /* evita rolagem horizontal */
    }

    .table thead th {
      position: sticky;    /* mantém cabeçalho fixo */
      top: 0;
      z-index: 2;
      background-color: #000; /* mantém cor do cabeçalho */
      color: #fff;
    }

    .total-box {
      margin-top: 5px;
      font-weight: bold;
      text-align: right;
    }
    
    
    @media (max-width: 768px) {
        .total-box {
      margin-top: 1px;
      font-weight: bold;
      text-align: right;
    }
    /* mantém a primeira coluna fixa durante rolagem horizontal */
.table-responsive {
  overflow-x: auto;
}

.table th:first-child,
.table td:first-child {
  position: sticky;
  left: 0;
  background-color: #fff;  /* mantém fundo */
  z-index: 3;              /* garante sobreposição */
  border-right: 1px solid #000; /* separador */
}

/* mantém alinhamento do cabeçalho da primeira coluna */
.table thead th:first-child {
  z-index: 4; 
  background-color: #000;
  color: #fff;
}

    
    }
  </style>
</head>
<body class="container mt-4">

    <h2 class="mb-3 text-center text-uppercase">Relat&oacute;rio de matr&iacute;culas 2026</h2>
    <h5 class="text-right text-uppercase">Atualização: 14/09/2025 14:30</h5>
    <!-- ================== Educação Infantil - Matutino ================== -->
    <h4 class="text-uppercase text-center">Educação Infantil - Matutino</h4>
    <div class="table-responsive">
        <table class="table table-bordered table-striped">
            <thead class="table-dark">
                <tr>
                    <th>Sala Matriz</th>
                    <th>Serie / Turma</th>
                    <th>Vagas Físicas</th>
                    <th>2025</th>
                    <th>Rematricula</th>
                    <th>Novatos</th>
                    <th>Matriculados</th>
                    <th>Vagas Atuais</th>
                    <th>Não rematricularam</th>
                    <th>Vagas Esperadas</th>
                </tr>
            </thead>
            <tbody>
                <?php if ($dadosedim): ?>
                    <?php foreach ($dadosedim as $row): ?>
                        <tr>
                            <td><?= htmlspecialchars($row['sala_matriz']) ?></td>
                            <td><?= htmlspecialchars($row['turma']) ?></td>
                            <td><?= htmlspecialchars($row['vagas_fisicas']) ?></td>
                            <td><?= htmlspecialchars($row['ano_anterior']) ?></td>
                            <td><?= htmlspecialchars($row['veteranos']) ?></td>
                            <td><?= htmlspecialchars($row['novatos']) ?></td>
                            <td><?= htmlspecialchars($row['matriculados']) ?></td>
                            <td><?= htmlspecialchars($row['vagas_restantes']) ?></td>
                            <td><?= htmlspecialchars($row['vagas_reais']) ?></td>
                            <?php $vagas = $row['vagas_restantes'] - $row['vagas_reais'] ;?>
                            <td><?= htmlspecialchars($vagas) ?></td>
                        </tr>
                    <?php endforeach; ?>
                <?php else: ?>
                    <tr><td colspan="10" class="text-center">Nenhum registro encontrado.</td></tr>
                <?php endif; ?>
            </tbody>
        </table>
    </div>

    <br><br>

    <!-- ================== Educação Infantil - Vespertino ================== -->
    <h4 class="text-uppercase text-center">Educação Infantil - Vespertino</h4>
    <div class="table-responsive">
        <table class="table table-bordered table-striped">
            <thead class="table-dark">
                <tr>
                    <th>Sala Matriz</th>
                    <th>Serie / Turma</th>
                    <th>Vagas Físicas</th>
                    <th>2025</th>
                    <th>Rematricula</th>
                    <th>Novatos</th>
                    <th>Matriculados</th>
                    <th>Vagas Atuais</th>
                    <th>Não rematricularam</th>
                    <th>Vagas Esperadas</th>
                </tr>
            </thead>
            <tbody>
                <?php if ($dadosediv): ?>
                    <?php foreach ($dadosediv as $row): ?>
                        <tr>
                            <td><?= htmlspecialchars($row['sala_matriz']) ?></td>
                            <td><?= htmlspecialchars($row['turma']) ?></td>
                            <td><?= htmlspecialchars($row['vagas_fisicas']) ?></td>
                            <td><?= htmlspecialchars($row['ano_anterior']) ?></td>
                            <td><?= htmlspecialchars($row['veteranos']) ?></td>
                            <td><?= htmlspecialchars($row['novatos']) ?></td>
                            <td><?= htmlspecialchars($row['matriculados']) ?></td>
                            <td><?= htmlspecialchars($row['vagas_restantes']) ?></td>
                            <td><?= htmlspecialchars($row['vagas_reais']) ?></td>
                            <?php $vagas = $row['vagas_restantes'] - $row['vagas_reais'] ;?>
                            <td><?= htmlspecialchars($vagas) ?></td>
                        </tr>
                    <?php endforeach; ?>
                <?php else: ?>
                    <tr><td colspan="10" class="text-center">Nenhum registro encontrado.</td></tr>
                <?php endif; ?>
            </tbody>
        </table>
    </div>

    <br><br>

    <!-- ================== Fundamental I - Matutino ================== -->
    <h4 class="text-uppercase text-center">Fundamental I - Matutino</h4>
    <div class="table-responsive">
        <table class="table table-bordered table-striped">
            <thead class="table-dark">
                <tr>
                    <th>Sala Matriz</th>
                    <th>Serie / Turma</th>
                    <th>Vagas Físicas</th>
                    <th>2025</th>
                    <th>Rematricula</th>
                    <th>Novatos</th>
                    <th>Matriculados</th>
                    <th>Vagas Atuais</th>
                    <th>Não rematricularam</th>
                    <th>Vagas Esperadas</th>
                </tr>
            </thead>
            <tbody>
                <?php if ($dadosf1m): ?>
                    <?php foreach ($dadosf1m as $row1): ?>
                        <tr>
                            <td><?= htmlspecialchars($row1['sala_matriz']) ?></td>
                            <td><?= htmlspecialchars($row1['turma']) ?></td>
                            <td><?= htmlspecialchars($row1['vagas_fisicas']) ?></td>
                            <td><?= htmlspecialchars($row1['ano_anterior']) ?></td>
                            <td><?= htmlspecialchars($row1['veteranos']) ?></td>
                            <td><?= htmlspecialchars($row1['novatos']) ?></td>
                            <td><?= htmlspecialchars($row1['matriculados']) ?></td>
                            <td><?= htmlspecialchars($row1['vagas_restantes']) ?></td>
                            <td><?= htmlspecialchars($row1['vagas_reais']) ?></td>
                            <?php $vagas1 = $row1['vagas_restantes'] - $row1['vagas_reais'] ;?>
                            <td><?= htmlspecialchars($vagas1) ?></td>
                        </tr>
                    <?php endforeach; ?>
                <?php else: ?>
                    <tr><td colspan="10" class="text-center">Nenhum registro encontrado.</td></tr>
                <?php endif; ?>
            </tbody>
        </table>
    </div>
    <br><br>
     <!-- ================== Fundamental I - Vespertino ================== -->
    <h4 class="text-uppercase text-center">Fundamental I - Vespertino</h4>
    <div class="table-responsive">
        <table class="table table-bordered table-striped">
            <thead class="table-dark">
                <tr>
                    <th>Sala Matriz</th>
                    <th>Serie / Turma</th>
                    <th>Vagas Físicas</th>
                    <th>2025</th>
                    <th>Rematricula</th>
                    <th>Novatos</th>
                    <th>Matriculados</th>
                    <th>Vagas Atuais</th>
                    <th>Não rematricularam</th>
                    <th>Vagas Esperadas</th>
                </tr>
            </thead>
            <tbody>
                <?php if ($dadosf1v): ?>
                    <?php foreach ($dadosf1v as $row1): ?>
                        <tr>
                            <td><?= htmlspecialchars($row1['sala_matriz']) ?></td>
                            <td><?= htmlspecialchars($row1['turma']) ?></td>
                            <td><?= htmlspecialchars($row1['vagas_fisicas']) ?></td>
                            <td><?= htmlspecialchars($row1['ano_anterior']) ?></td>
                            <td><?= htmlspecialchars($row1['veteranos']) ?></td>
                            <td><?= htmlspecialchars($row1['novatos']) ?></td>
                            <td><?= htmlspecialchars($row1['matriculados']) ?></td>
                            <td><?= htmlspecialchars($row1['vagas_restantes']) ?></td>
                            <td><?= htmlspecialchars($row1['vagas_reais']) ?></td>
                            <?php $vagas1 = $row1['vagas_restantes'] - $row1['vagas_reais'] ;?>
                            <td><?= htmlspecialchars($vagas1) ?></td>
                        </tr>
                    <?php endforeach; ?>
                <?php else: ?>
                    <tr><td colspan="10" class="text-center">Nenhum registro encontrado.</td></tr>
                <?php endif; ?>
            </tbody>
        </table>
    </div>
    <br><br>
     <!-- ================== Fundamental II - Matutino ================== -->
    <h4 class="text-uppercase text-center">Fundamental II - Matutino</h4>
    <div class="table-responsive">
        <table class="table table-bordered table-striped">
            <thead class="table-dark">
                <tr>
                    <th>Sala Matriz</th>
                    <th>Serie / Turma</th>
                    <th>Vagas Físicas</th>
                    <th>2025</th>
                    <th>Rematricula</th>
                    <th>Novatos</th>
                    <th>Matriculados</th>
                    <th>Vagas Atuais</th>
                    <th>Não rematricularam</th>
                    <th>Vagas Esperadas</th>
                </tr>
            </thead>
            <tbody>
                <?php if ($dadosf2m): ?>
                    <?php foreach ($dadosf2m as $row1): ?>
                        <tr>
                            <td><?= htmlspecialchars($row1['sala_matriz']) ?></td>
                            <td><?= htmlspecialchars($row1['turma']) ?></td>
                            <td><?= htmlspecialchars($row1['vagas_fisicas']) ?></td>
                            <td><?= htmlspecialchars($row1['ano_anterior']) ?></td>
                            <td><?= htmlspecialchars($row1['veteranos']) ?></td>
                            <td><?= htmlspecialchars($row1['novatos']) ?></td>
                            <td><?= htmlspecialchars($row1['matriculados']) ?></td>
                            <td><?= htmlspecialchars($row1['vagas_restantes']) ?></td>
                            <td><?= htmlspecialchars($row1['vagas_reais']) ?></td>
                            <?php $vagas1 = $row1['vagas_restantes'] - $row1['vagas_reais'] ;?>
                            <td><?= htmlspecialchars($vagas1) ?></td>
                        </tr>
                    <?php endforeach; ?>
                <?php else: ?>
                    <tr><td colspan="10" class="text-center">Nenhum registro encontrado.</td></tr>
                <?php endif; ?>
            </tbody>
        </table>
    </div>
       <br><br>
     <!-- ==================Ensino Medio ================== -->
    <h4 class="text-uppercase text-center">Ensino Médio - Matutino</h4>
    <div class="table-responsive">
        <table class="table table-bordered table-striped">
            <thead class="table-dark">
                <tr>
                    <th>Sala Matriz</th>
                    <th>Serie / Turma</th>
                    <th>Vagas Físicas</th>
                    <th>2025</th>
                    <th>Rematricula</th>
                    <th>Novatos</th>
                    <th>Matriculados</th>
                    <th>Vagas Atuais</th>
                    <th>Não rematricularam</th>
                    <th>Vagas Esperadas</th>
                </tr>
            </thead>
            <tbody>
                <?php if ($dadosem): ?>
                    <?php foreach ($dadosem as $row1): ?>
                        <tr>
                            <td><?= htmlspecialchars($row1['sala_matriz']) ?></td>
                            <td><?= htmlspecialchars($row1['turma']) ?></td>
                            <td><?= htmlspecialchars($row1['vagas_fisicas']) ?></td>
                            <td><?= htmlspecialchars($row1['ano_anterior']) ?></td>
                            <td><?= htmlspecialchars($row1['veteranos']) ?></td>
                            <td><?= htmlspecialchars($row1['novatos']) ?></td>
                            <td><?= htmlspecialchars($row1['matriculados']) ?></td>
                            <td><?= htmlspecialchars($row1['vagas_restantes']) ?></td>
                            <td><?= htmlspecialchars($row1['vagas_reais']) ?></td>
                            <?php $vagas1 = $row1['vagas_restantes'] - $row1['vagas_reais'] ;?>
                            <td><?= htmlspecialchars($vagas1) ?></td>
                        </tr>
                    <?php endforeach; ?>
                <?php else: ?>
                    <tr><td colspan="10" class="text-center">Nenhum registro encontrado.</td></tr>
                <?php endif; ?>
            </tbody>
        </table>
    </div>
    
</body>

</html>
