<?php
// === Conexão com o banco (PDO) ===
$host = "localhost";
$user = "kaltekgo_admin";       
$pass = "kaltek@2024";          
$db   = "kaltekgo_avila";       

try {
    $pdo = new PDO("mysql:host=$host;dbname=$db;charset=utf8", $user, $pass);
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
} catch (PDOException $e) {
    die("Erro de conexão: " . $e->getMessage());
}

// === Buscar última atualização ===
$sqlData = "SELECT data_atualizacao 
              FROM calouros_veteranos 
          ORDER BY data_atualizacao DESC 
             LIMIT 1";
$stmt = $pdo->query($sqlData);
$ultimaAtualizacao = $stmt->fetchColumn();
$dataFormatada = $ultimaAtualizacao 
    ? date("d/m/Y H:i", strtotime($ultimaAtualizacao)) 
    : "Sem registros";
    
// === Buscar todos os alunos matriculados ===
$sqlAlunos = "SELECT 
                 matricula, 
                 nomeAluno, 
                 turma, 
                 data_matricula 
              FROM calouros_veteranos 
              ORDER BY data_matricula DESC";
$stmt = $pdo->query($sqlAlunos);
$dadosAlunos = $stmt->fetchAll(PDO::FETCH_ASSOC);


/* ================== CONSULTAS ================== */
// (Mantendo todas as consultas que você já tinha)
$sqledim = "SELECT v.sala_matriz, v.turma_nome AS turma, v.vagas_fisicas, v.ano_2025 AS ano_anterior, v.id, v.tooltip,
    COUNT(c.turma) AS matriculados,
    SUM(CASE WHEN c.veterano = 1 THEN 1 ELSE 0 END) AS veteranos,
    SUM(CASE WHEN c.calouro = 1 THEN 1 ELSE 0 END) AS novatos,
    (v.vagas_fisicas - COUNT(c.turma)) AS vagas_restantes,
    (v.ano_2025 - SUM(CASE WHEN c.veterano = 1 THEN 1 ELSE 0 END)) AS vagas_reais
FROM vagas_series_turmas v
LEFT JOIN calouros_veteranos c ON v.turma_nome = c.turma
WHERE v.id BETWEEN 1 AND 13 
  AND turno = 'matutino'
GROUP BY v.sala_matriz, v.turma_nome, v.vagas_fisicas, v.ano_2025, v.id, v.tooltip
ORDER BY v.id ASC;
";
$stmt = $pdo->query($sqledim);
$dadosedim = $stmt->fetchAll(PDO::FETCH_ASSOC);

// Educação Infantil - Vespertino
$sqlediv = "SELECT v.sala_matriz, v.turma_nome AS turma, v.vagas_fisicas, v.ano_2025 AS ano_anterior, v.id, v.tooltip,
    COUNT(c.turma) AS matriculados,
    SUM(CASE WHEN c.veterano = 1 THEN 1 ELSE 0 END) AS veteranos,
    SUM(CASE WHEN c.calouro = 1 THEN 1 ELSE 0 END) AS novatos,
    (v.vagas_fisicas - COUNT(c.turma)) AS vagas_restantes,
    (v.ano_2025 - SUM(CASE WHEN c.veterano = 1 THEN 1 ELSE 0 END)) AS vagas_reais
FROM vagas_series_turmas v
LEFT JOIN calouros_veteranos c ON v.turma_nome = c.turma
WHERE v.id BETWEEN 1 AND 13 
  AND turno = 'vespertino'
GROUP BY v.sala_matriz, v.turma_nome, v.vagas_fisicas, v.ano_2025, v.id, v.tooltip
ORDER BY v.id ASC";
$stmt = $pdo->query($sqlediv);
$dadosediv = $stmt->fetchAll(PDO::FETCH_ASSOC);

// Fundamental I - Matutino
$sqlf1m = "SELECT v.sala_matriz, v.turma_nome AS turma, v.vagas_fisicas, v.ano_2025 AS ano_anterior, v.id, v.tooltip,
    COUNT(c.turma) AS matriculados,
    SUM(CASE WHEN c.veterano = 1 THEN 1 ELSE 0 END) AS veteranos,
    SUM(CASE WHEN c.calouro = 1 THEN 1 ELSE 0 END) AS novatos,
    (v.vagas_fisicas - COUNT(c.turma)) AS vagas_restantes,
    (v.ano_2025 - SUM(CASE WHEN c.veterano = 1 THEN 1 ELSE 0 END)) AS vagas_reais
FROM vagas_series_turmas v
LEFT JOIN calouros_veteranos c ON v.turma_nome = c.turma
WHERE v.id  BETWEEN 15 AND 32 AND v.turno = 'matutino'
GROUP BY v.sala_matriz, v.turma_nome, v.vagas_fisicas, v.ano_2025, v.id, v.tooltip
ORDER BY v.id ASC";
$stmt = $pdo->query($sqlf1m);
$dadosf1m = $stmt->fetchAll(PDO::FETCH_ASSOC);

// Fundamental I - Vespertino
$sqlf1v = str_replace("matutino", "vespertino", $sqlf1m);
$stmt = $pdo->query($sqlf1v);
$dadosf1v = $stmt->fetchAll(PDO::FETCH_ASSOC);

// Fundamental II - Matutino
$sqlf2m = "SELECT v.sala_matriz, v.turma_nome AS turma, v.vagas_fisicas, v.ano_2025 AS ano_anterior, v.id, v.tooltip,
    COUNT(c.turma) AS matriculados,
    SUM(CASE WHEN c.veterano = 1 THEN 1 ELSE 0 END) AS veteranos,
    SUM(CASE WHEN c.calouro = 1 THEN 1 ELSE 0 END) AS novatos,
    (v.vagas_fisicas - COUNT(c.turma)) AS vagas_restantes,
    (v.ano_2025 - SUM(CASE WHEN c.veterano = 1 THEN 1 ELSE 0 END)) AS vagas_reais
FROM vagas_series_turmas v
LEFT JOIN calouros_veteranos c ON v.turma_nome = c.turma
WHERE (v.turma_nome LIKE '%6º%' OR v.turma_nome LIKE '%7º%' OR v.turma_nome LIKE '%8º%' OR v.turma_nome LIKE '%9º%')
  AND turno = 'matutino'
GROUP BY v.sala_matriz, v.turma_nome, v.vagas_fisicas, v.ano_2025, v.id, v.tooltip
ORDER BY v.id ASC";
$stmt = $pdo->query($sqlf2m);
$dadosf2m = $stmt->fetchAll(PDO::FETCH_ASSOC);

// Ensino Médio - Matutino
$sqlem = "SELECT v.sala_matriz, v.turma_nome AS turma, v.vagas_fisicas, v.ano_2025 AS ano_anterior, v.id, v.tooltip,
    COUNT(c.turma) AS matriculados,
    SUM(CASE WHEN c.veterano = 1 THEN 1 ELSE 0 END) AS veteranos,
    SUM(CASE WHEN c.calouro = 1 THEN 1 ELSE 0 END) AS novatos,
    (v.vagas_fisicas - COUNT(c.turma)) AS vagas_restantes,
    (v.ano_2025 - SUM(CASE WHEN c.veterano = 1 THEN 1 ELSE 0 END)) AS vagas_reais
FROM vagas_series_turmas v
LEFT JOIN calouros_veteranos c ON v.turma_nome = c.turma
WHERE v.id BETWEEN 41 AND 43
  AND turno = 'matutino'
GROUP BY v.sala_matriz, v.turma_nome, v.vagas_fisicas, v.ano_2025, v.id, v.tooltip
ORDER BY v.id ASC";
$stmt = $pdo->query($sqlem);
$dadosem = $stmt->fetchAll(PDO::FETCH_ASSOC);

// Todas as salas
$sqlall = "SELECT v.sala_matriz, v.turma_nome AS turma, v.vagas_fisicas, v.ano_2025 AS ano_anterior, v.id, v.tooltip,
    COUNT(c.turma) AS matriculados,
    SUM(CASE WHEN c.veterano = 1 THEN 1 ELSE 0 END) AS veteranos,
    SUM(CASE WHEN c.calouro = 1 THEN 1 ELSE 0 END) AS novatos,
    (v.vagas_fisicas - COUNT(c.turma)) AS vagas_restantes,
    (v.ano_2025 - SUM(CASE WHEN c.veterano = 1 THEN 1 ELSE 0 END)) AS vagas_reais
FROM vagas_series_turmas v
LEFT JOIN calouros_veteranos c ON v.turma_nome = c.turma
GROUP BY v.sala_matriz, v.turma_nome, v.vagas_fisicas, v.ano_2025, v.id, v.tooltip
ORDER BY v.id ASC";
$stmt = $pdo->query($sqlall);
$dadosall = $stmt->fetchAll(PDO::FETCH_ASSOC);


/* ================== FUNÇÃO DA TABELA ================== */
function renderTabela($dados) {
    // Inicializa acumuladores
    $total_vagas_fisicas = 0;
    //$total_ano_anterior  = 0;
    $total_veteranos     = 0;
    $total_novatos       = 0;
    $total_matriculados  = 0;
    $total_vagas_rest    = 0;
    $total_vagas_reais   = 0;
    $total_vagas_esp     = 0;
    ?>
    <div class="table-responsive">
      <table class="table table-bordered table-striped">
        <thead>
          <tr>
            <th>Sala Matriz</th>
            <th>Série / Turma</th>
            <th>Vagas Físicas</th>
            <th>Ano Anterior - 2025</th>
            <th>Rematricula</th>
            <th>Novatos</th>
            <th>Matriculados</th>
            <th>Vagas Atuais</th>
            <th>Não rematricularam</th>
            <th>Vagas Esperadas</th>
          </tr>
        </thead>
        <tbody>
          <?php if ($dados): ?>
            <?php foreach ($dados as $row): ?>
              <?php
                $vagas_esp = $row['vagas_restantes'] - $row['vagas_reais'];
                // Somatórios
                $total_vagas_fisicas += $row['vagas_fisicas'];
                //$total_ano_anterior  += $row['ano_anterior'];
                $total_veteranos     += $row['veteranos'];
                $total_novatos       += $row['novatos'];
                $total_matriculados  += $row['matriculados'];
                $total_vagas_rest    += $row['vagas_restantes'];
                $total_vagas_reais   += $row['vagas_reais'];
                $total_vagas_esp     += $vagas_esp;
              ?>
              <tr>
                <td><?= htmlspecialchars($row['sala_matriz']) ?></td>
                <td><?= htmlspecialchars($row['turma']) ?></td>
                <td><?= htmlspecialchars($row['vagas_fisicas']) ?></td>
                <td>
  <?= htmlspecialchars($row['ano_anterior']) ?>
  <?php if (in_array($row['id'], [25,33,34,41])): ?>
    <span data-toggle="tooltip" title="<?= htmlspecialchars($row['tooltip']) ?>" style="color: red; font-size: 15px;"> *</span>
  <?php endif; ?>
</td>

                <td><?= htmlspecialchars($row['veteranos']) ?></td>
                <td><?= htmlspecialchars($row['novatos']) ?></td>
                <td><?= htmlspecialchars($row['matriculados']) ?></td>
                <td><?= htmlspecialchars($row['vagas_restantes']) ?></td>
                <td><?= htmlspecialchars($row['vagas_reais']) ?></td>
                <td><?= htmlspecialchars($vagas_esp) ?></td>
              </tr>
            <?php endforeach; ?>
          <?php else: ?>
            <tr><td colspan="10" class="text-center">Nenhum registro encontrado.</td></tr>
          <?php endif; ?>
        </tbody>
        <?php if ($dados): ?>
        <tfoot>
          <tr style="font-weight: bold; background: #d9edf7;">
            <td colspan="2" class="text-right">TOTAL:</td>
            <td><?= $total_vagas_fisicas ?></td>
            <td><?= $total_ano_anterior ?></td>
            <td><?= $total_veteranos ?></td>
            <td><?= $total_novatos ?></td>
            <td><?= $total_matriculados ?></td>
            <td><?= $total_vagas_rest ?></td>
            <td><?= $total_vagas_reais ?></td>
            <td><?= $total_vagas_esp ?></td>
          </tr>
          <?php if ($dados): ?>
          <tr style="font-weight: bold; background: #d9edf7;">
            <td colspan="2" class="text-right">TOTAL(R$):</td>
            <td><?php $total_vagas_fisicas?></td>
            <td><?php $total_ano_anterior ?></td>
            <td><?= "R$ " . number_format($total_veteranos*1950.00, 2, ',', '.') ?></td>
            <td><?= "R$ " . number_format($total_novatos*1950.00, 2, ',', '.') ?></td>
            <td><?= "R$ " . number_format($total_matriculados*1950.00, 2, ',', '.') ?></td>
            <td><?php $total_vagas_rest ?></td>
            <td><?php $total_vagas_reais ?></td>
            <td><?php $total_vagas_esp ?></td>
          </tr>
        <?php endif; ?>
        </tfoot>
        <?php endif; ?>
        
      </table>
    </div>
    <?php
}

/* ================== FUNÇÃO TABELA DE ALUNOS ================== */
function renderTabelaAlunos($dadosAlunos) {
    ?>
    <div class="table-responsive" style="max-height: 500px; overflow-y: auto;">
  <table class="table table-bordered table-striped">

        <thead>
          <tr>
            <th>Matrícula</th>
            <th>Nome do Aluno</th>
            <th>Turma</th>
            <th>Data da Matrícula</th>
          </tr>
        </thead>
        <tbody>
          <?php if ($dadosAlunos): ?>
            <?php foreach ($dadosAlunos as $row): ?>
              <tr>
                <td><?= htmlspecialchars($row['matricula']) ?></td>
                <td><?= htmlspecialchars($row['nomeAluno']) ?></td>
                <td><?= htmlspecialchars($row['turma']) ?></td>
                <td><?= date("d/m/Y", strtotime($row['data_matricula'])) ?></td>
              </tr>
            <?php endforeach; ?>
          <?php else: ?>
            <tr><td colspan="4" class="text-center">Nenhum aluno encontrado.</td></tr>
          <?php endif; ?>
        </tbody>
      </table>
    </div>
    <?php
}

/* ================== INTERFACE ================== */
$data_atual = new DateTime();
$proximo_ano = $data_atual->modify('+1 year')->format('Y');

function somaNovatos($dados) { 
    $total = 0; foreach ($dados as $row) $total += $row['novatos']; 
    return $total; 
}
function somaVeteranos($dados) { 
    $total = 0; foreach ($dados as $row) $total += $row['veteranos']; 
    return $total; 
}


?>
<!DOCTYPE html>
<html lang="pt-br">
<head>
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <meta charset="UTF-8">
  <title>Relat&oacute;rio de alunos matriculados</title>
  <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/3.4.1/css/bootstrap.min.css">
  <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
  <script src="https://maxcdn.bootstrapcdn.com/bootstrap/3.4.1/js/bootstrap.min.js"></script>
  <style>
     body { font-family: Arial, sans-serif; background-color: #ffffff; margin: 20px; color: #000; }
     table { white-space: nowrap; width: 100%; border-collapse: collapse; background-color: #fff; text-transform: uppercase; }
     th, td { padding: 12px 15px; text-align: left; font-size: 12px; border: 1px solid #000; }
     th { background-color: #000; color: #fff; }
     tr:nth-child(even) { background-color: #f4f4f4; }
     tr:hover { background-color: #e0e0e0; }
     .table-responsive { overflow-x: auto; }
     .table thead th { position: sticky; top: 0; z-index: 2; background-color: #000; color: #fff; }
     @media (max-width: 768px) {
       .table th:first-child, .table td:first-child { position: sticky; left: 0; background-color: #fff; z-index: 3; border-right: 1px solid #000; }
       .table thead th:first-child { z-index: 4; background-color: #000; color: #fff; }
     }
  </style>
</head>
<body class="container-fluid">

<h2 class="text-center text-uppercase">Computo de matr&iacute;culas <?= $proximo_ano ?></h2>
<h5 class="text-right text-uppercase">Atualização: <?= $dataFormatada ?></h5>

<ul class="nav nav-tabs">
  <li class="active"><a data-toggle="tab" href="#edim">Educação Infantil - Matutino</a></li>
  <li><a data-toggle="tab" href="#ediv">Educação Infantil - Vespertino</a></li>
  <li><a data-toggle="tab" href="#f1m">Fundamental I - Matutino</a></li>
  <li><a data-toggle="tab" href="#f1v">Fundamental I - Vespertino</a></li>
  <li><a data-toggle="tab" href="#f2m">Fundamental II - Matutino</a></li>
  <li><a data-toggle="tab" href="#em">Ensino Médio - Matutino</a></li>
  <li><a data-toggle="tab" href="#todas">Todas as Turmas</a></li>
  <li><a data-toggle="tab" href="#alunos">Alunos Matriculados</a></li>

</ul>
<br>

<div class="tab-content">
  <div id="edim" class="tab-pane fade in active">
    <h4 class="text-uppercase text-center">Educação Infantil - Matutino</h4>
    <?php renderTabela($dadosedim); ?>
  </div>
  <div id="ediv" class="tab-pane fade">
    <h4 class="text-uppercase text-center">Educação Infantil - Vespertino</h4>
    <?php renderTabela($dadosediv); ?>
  </div>
  <div id="f1m" class="tab-pane fade">
    <h4 class="text-uppercase text-center">Fundamental I - Matutino</h4>
    <?php renderTabela($dadosf1m); ?>
  </div>
  <div id="f1v" class="tab-pane fade">
    <h4 class="text-uppercase text-center">Fundamental I - Vespertino</h4>
    <?php renderTabela($dadosf1v); ?>
  </div>
  <div id="f2m" class="tab-pane fade">
    <h4 class="text-uppercase text-center">Fundamental II - Matutino</h4>
    <?php renderTabela($dadosf2m); ?>
  </div>
  <div id="em" class="tab-pane fade">
    <h4 class="text-uppercase text-center">Ensino Médio - Matutino</h4>
    <?php renderTabela($dadosem); ?>
  </div>
  <div id="todas" class="tab-pane fade">
    <h4 class="text-uppercase text-center">Todas as Turmas</h4>
    <?php renderTabela($dadosall); ?>
  </div>
  <div id="alunos" class="tab-pane fade">
    <h4 class="text-uppercase text-center">Alunos Matriculados</h4>
    <?php renderTabelaAlunos($dadosAlunos); ?>
  </div>
</div>



<!-- TABELA INTERMEDIÁRIA -->
<div class="table-responsive">
<h4 class="text-uppercase text-center">Metas de matrículas para 2026</h4>
  <table class="table table-bordered table-striped">
    <thead>
      <tr style="background:#000; color:#fff; text-transform:uppercase;">
        <th>Acumulados Mês</th>
        <th>Novatos</th>
        <th>Rematrícula</th>
      </tr>
    </thead>
    <tbody>
      <tr>
        <td>Setembro (2025)</td>
        <td>33</td>
        <td>257</td>
      </tr>
      <tr>
        <td>Atualmente (Setembro 2026)</td>
        <td><?= somaNovatos($dadosall) ?></td>
        <td><?= somaVeteranos($dadosall) ?></td>
      </tr>
      <tr>
        <tr>
  <td>Atualmente R$ (Setembro 2026)</td>
  <td><?= "R$ " . number_format(somaNovatos($dadosall)*1850.00, 2, ',', '.') ?></td>
  <td><?= "R$ " . number_format(somaVeteranos($dadosall)*1850.00, 2, ',', '.') ?></td>
</tr>
      </tr>
    </tbody>
  </table>
</div>

<hr>

<!-- TABELA DE TOTAIS GERAIS -->
<?php
// Funções para somar matriculados e vagas esperadas
function somaMatriculados($dados) { $total = 0; foreach ($dados as $row) $total += $row['matriculados']; return $total; }
function somaesp($dados) { $total = 0; foreach ($dados as $row) { $total += $row['vagas_restantes'] - $row['vagas_reais']; } return $total; }

$total_ed_infantil = somaMatriculados($dadosedim) + somaMatriculados($dadosediv);
$total_fund1       = somaMatriculados($dadosf1m) + somaMatriculados($dadosf1v);
$total_fund2       = somaMatriculados($dadosf2m);
$total_medio       = somaMatriculados($dadosem);
$total_geral       = somaMatriculados($dadosall);
?>

<div class="table-responsive">
  <table class="table table-bordered table-striped">
    <thead>
      <tr style="background:#000; color:#fff; text-transform:uppercase;">
        <th>Nível</th>
        <th>Total Matriculados</th>
        <th>Vagas Esperadas</th>
      </tr>
    </thead>
    <tbody>
      <tr><td>Educação Infantil</td><td><?= $total_ed_infantil ?></td><td><?= somaesp(array_merge($dadosedim,$dadosediv)) ?></td></tr>
      <tr><td>Fundamental I</td><td><?= $total_fund1 ?></td><td><?= somaesp(array_merge($dadosf1m,$dadosf1v)) ?></td></tr>
      <tr><td>Fundamental II</td><td><?= $total_fund2 ?></td><td><?= somaesp($dadosf2m) ?></td></tr>
      <tr><td>Ensino Médio</td><td><?= $total_medio ?></td><td><?= somaesp($dadosem) ?></td></tr>
      <tr style="font-weight:bold; background:#000; color:#fff;"><td>Total Geral</td><td><?=$total_geral?> - (<?= "R$ " . number_format($total_geral*1850.00, 2, ',', '.') ?>)</td><td><?= somaesp($dadosall) ?></td></tr>
    </tbody>
  </table>
</div>

<script>
$(document).ready(function(){
  $('[data-toggle="tooltip"]').tooltip();   
});
</script>

</body>
</html>
