<?php
header('Content-Type: application/json; charset=utf-8');

// ============================================
// Conexão com PostgreSQL
// ============================================
$pg_host     = "192.168.10.11";
$pg_port     = "5432";
$pg_dbname   = "seibd";
$pg_user     = "usr_leitura_avila";
$pg_password = "j*mD+cJw";

try {
    $pg_pdo = new PDO("pgsql:host=$pg_host;port=$pg_port;dbname=$pg_dbname", $pg_user, $pg_password);
    $pg_pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
} catch (PDOException $e) {
    echo json_encode(["erro" => "Falha na conexão PostgreSQL: " . $e->getMessage()]);
    exit;
}

// ============================================
// Conexão com MySQL
// ============================================
$mysql_host = "localhost";
$mysql_db   = "kaltekgo_avila";
$mysql_user = "kaltekgo_admin";
$mysql_pass = "kaltek@2024";

try {
    $my_pdo = new PDO("mysql:host=$mysql_host;dbname=$mysql_db;charset=utf8", $mysql_user, $mysql_pass);
    $my_pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
} catch (PDOException $e) {
    echo json_encode(["erro" => "Falha na conexão MySQL: " . $e->getMessage()]);
    exit;
}

// ============================================
// Query no PostgreSQL
// ============================================
$sql = "
WITH veterano_check AS (
    SELECT 
        m.aluno,
        mp.ano::INT AS ano
    FROM matricula m
    INNER JOIN matriculaperiodo mp ON mp.matricula = m.matricula
    WHERE mp.ano IS NOT NULL 
      AND mp.ano <> ''
      AND mp.situacaomatriculaperiodo IN ('AT','FI')
)
SELECT 
    ue.nome AS campo1,                  
    c.nome AS campo2,                   
    t.identificadorturma AS campo3,     
    ma.matricula AS campo4,             
    a.nome AS campo5,                   

    CASE WHEN v.aluno IS NULL THEN 1 ELSE 0 END AS campo6, -- Novato
    CASE WHEN v.aluno IS NOT NULL THEN 1 ELSE 0 END AS campo7, -- Veterano

    a.sexo AS campo8,                   
    ma.data AS campo9,                  

    c.nome AS agrupador1,
    ue.nome AS agrupador0

FROM matricula ma
INNER JOIN matriculaperiodo mp 
        ON mp.matricula = ma.matricula
INNER JOIN periodoletivo pl 
        ON mp.periodoletivomatricula = pl.codigo
INNER JOIN turma t 
        ON mp.turma = t.codigo
INNER JOIN unidadeensino ue 
        ON ue.codigo = ma.unidadeensino
INNER JOIN curso c 
        ON c.codigo = ma.curso
INNER JOIN turno tu 
        ON tu.codigo = ma.turno
INNER JOIN pessoa a 
        ON a.codigo = ma.aluno

LEFT JOIN veterano_check v 
       ON v.aluno = ma.aluno
      AND v.ano = (mp.ano::INT - 1)

WHERE ue.codigo IN (0, 6, 4, 3, 1)
  AND c.codigo IN (38, 5, 4, 1)
  AND mp.situacaomatriculaperiodo IN ('AT','TI','JU')
  AND mp.situacao IN ('CO','AT')
  AND tu.codigo IN (10, 5, 6)
  AND mp.ano = '2026'
  AND mp.ano IS NOT NULL 
  AND mp.ano <> ''

GROUP BY 
    ue.nome, c.nome, t.identificadorturma, 
    ma.matricula, a.nome, a.sexo, ma.data, v.aluno

ORDER BY 
    agrupador1, agrupador0, campo1 ASC, campo2 ASC, campo3 ASC, 
    campo5 ASC, campo8 ASC, campo9 ASC
";

try {
    $stmt = $pg_pdo->query($sql);
    $dados = $stmt->fetchAll(PDO::FETCH_ASSOC);
} catch (PDOException $e) {
    echo json_encode(["erro" => "Falha ao executar consulta PostgreSQL: " . $e->getMessage()]);
    exit;
}

// ============================================
// Limpar tabela no MySQL e inserir novos dados
// ============================================
try {
    $my_pdo->exec("TRUNCATE TABLE calouros_veternos");

    $insert_sql = "
        INSERT INTO calouros_veternos
        (campo1, campo2, campo3, campo4, campo5, campo6, campo7, campo8, campo9, agrupador1, agrupador0)
        VALUES (:campo1, :campo2, :campo3, :campo4, :campo5, :campo6, :campo7, :campo8, :campo9, :agrupador1, :agrupador0)
    ";

    $insert_stmt = $my_pdo->prepare($insert_sql);

    foreach ($dados as $row) {
        $insert_stmt->execute([
            ':campo1' => $row['campo1'],
            ':campo2' => $row['campo2'],
            ':campo3' => $row['campo3'],
            ':campo4' => $row['campo4'],
            ':campo5' => $row['campo5'],
            ':campo6' => $row['campo6'],
            ':campo7' => $row['campo7'],
            ':campo8' => $row['campo8'],
            ':campo9' => $row['campo9'],
            ':agrupador1' => $row['agrupador1'],
            ':agrupador0' => $row['agrupador0'],
        ]);
    }

    echo json_encode([
        "status" => "✅ Sucesso",
        "mensagem" => "Dados importados do PostgreSQL para MySQL",
        "total_registros" => count($dados)
    ], JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE);

} catch (PDOException $e) {
    echo json_encode(["erro" => "Falha ao inserir no MySQL: " . $e->getMessage()]);
}
