<?php
function renderTabela($dados) {
    ?>
    <div class="table-responsive">
      <table class="table table-bordered table-striped">
        <thead>
          <tr>
            <th>Sala Matriz</th>
            <th>Série / Turma</th>
            <th>Vagas Físicas</th>
            <th>2025</th>
            <th>Rematricula</th>
            <th>Novatos</th>
            <th>Matriculados</th>
            <th>Vagas Atuais</th>
            <th>Não rematricularam</th>
            <th>Vagas Esperadas</th>
          </tr>
        </thead>
        <tbody>
          <?php if ($dados): ?>
            <?php foreach ($dados as $row): ?>
              <tr>
                <td><?= htmlspecialchars($row['sala_matriz']) ?></td>
                <td><?= htmlspecialchars($row['turma']) ?></td>
                <td><?= htmlspecialchars($row['vagas_fisicas']) ?></td>
                <td><?= htmlspecialchars($row['ano_anterior']) ?></td>
                <td><?= htmlspecialchars($row['veteranos']) ?></td>
                <td><?= htmlspecialchars($row['novatos']) ?></td>
                <td><?= htmlspecialchars($row['matriculados']) ?></td>
                <td><?= htmlspecialchars($row['vagas_restantes']) ?></td>
                <td><?= htmlspecialchars($row['vagas_reais']) ?></td>
                <?php $vagas = $row['vagas_restantes'] - $row['vagas_reais']; ?>
                <td><?= htmlspecialchars($vagas) ?></td>
              </tr>
            <?php endforeach; ?>
          <?php else: ?>
            <tr><td colspan="10" class="text-center">Nenhum registro encontrado.</td></tr>
          <?php endif; ?>
        </tbody>
      </table>
    </div>
    <?php
}
?>