<?php
// Conexão com o banco
$host = 'localhost';
$db = 'kaltekgo_avila';
$user = 'kaltekgo_admin';
$pass = 'kaltek@2024';

try {
    $pdo = new PDO("mysql:host=$host;dbname=$db;charset=utf8", $user, $pass);
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
} catch (Exception $e) {
    die("Erro de conexão: " . $e->getMessage());
}

// Verifica se foi passado o ID
$id = $_GET['id'] ?? 3;

if (!$id) {
    die("ID do aluno não fornecido.");
}

// Busca os dados do aluno
$stmt = $pdo->prepare("SELECT * FROM alunos WHERE id = ?");
$stmt->execute([$id]);
$aluno = $stmt->fetch(PDO::FETCH_ASSOC);

if (!$aluno) {
    die("Aluno não encontrado.");
}
?>

<!DOCTYPE html>
<html lang="pt-br">
<head>
    <meta charset="UTF-8" />
    <title>Editar Aluno</title>
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no" />
    
    <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/3.3.7/css/bootstrap.min.css" />
    <style>
      body {
        margin-top: 20px;
      }
    </style>

    <!-- jQuery + jQuery Mask -->
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery.mask/1.14.16/jquery.mask.min.js"></script>
</head>
<body class="container">

    <h2>Atualização de Dados do Aluno</h2>

    <form action="salvar_edicao.php" method="POST">
        <input type="hidden" name="id" value="<?= htmlspecialchars($aluno['id']) ?>" />

        <div class="form-group">
            <label>Nome do Aluno</label>
            <input type="text" class="form-control" name="nomeAluno" value="<?= htmlspecialchars($aluno['nomeAluno']) ?>" disabled/>
        </div>

        <div class="form-group">
            <label>Identificador da Turma</label>
            <input type="text" class="form-control" name="identificadorTurma" value="<?= htmlspecialchars($aluno['identificadorTurma']) ?>" disabled />
        </div>

        <div class="form-group">
            <label>Nome do Pai</label>
            <input type="text" class="form-control" name="nomePai" value="<?= htmlspecialchars($aluno['nomePai']) ?>" />
        </div>

        <div class="form-group">
            <label>Telefone do Pai</label>
            <input type="text" class="form-control telefone" name="telefonePai" value="<?= htmlspecialchars($aluno['telefonePai']) ?>" />
        </div>

        <div class="form-group">
            <label>Nome da Mãe</label>
            <input type="text" class="form-control" name="nomeMae" value="<?= htmlspecialchars($aluno['nomeMae']) ?>" />
        </div>

        <div class="form-group">
            <label>Telefone da Mãe</label>
            <input type="text" class="form-control telefone" name="telefoneMae" value="<?= htmlspecialchars($aluno['telefoneMae']) ?>" />
        </div>

        <div class="form-group">
            <label>Telefone Responsável Legal</label>
            <input type="text" class="form-control telefone" name="telefoneRespLegal" value="<?= htmlspecialchars($aluno['telefoneRespLegal']) ?>" />
        </div>

        <button type="button" class="btn btn-primary" id="btnConfirmar">Salvar Alterações</button>
        <a href="lista_alunos.php" class="btn btn-default">Cancelar</a>
    </form>

    <!-- Modal de Confirmação -->
    <div class="modal fade" id="confirmModal" tabindex="-1" role="dialog" aria-labelledby="confirmModalLabel">
      <div class="modal-dialog" role="document">
        <div class="modal-content">
          <div class="modal-header">
            <h4 class="modal-title" id="confirmModalLabel">Confirmar Dados</h4>
          </div>
          <div class="modal-body">
            <p><strong>Nome do Pai:</strong> <span id="confNomePai"></span></p>
            <p><strong>Telefone do Pai:</strong> <span id="confTelefonePai"></span></p>
            <p><strong>Nome da Mãe:</strong> <span id="confNomeMae"></span></p>
            <p><strong>Telefone da Mãe:</strong> <span id="confTelefoneMae"></span></p>
            <p><strong>Telefone Responsável Legal:</strong> <span id="confTelefoneRespLegal"></span></p>
          </div>
          <div class="modal-footer">
            <button type="button" class="btn btn-default" data-dismiss="modal">Cancelar</button>
            <button type="button" class="btn btn-success" id="confirmarEnvio">Confirmar e Salvar</button>
          </div>
        </div>
      </div>
    </div>
    <br><br>
    <!-- Scripts do Bootstrap -->
    <script src="https://maxcdn.bootstrapcdn.com/bootstrap/3.3.7/js/bootstrap.min.js"></script>

    <script>
    $(document).ready(function(){

        // Máscara de telefone dinâmica
        var behavior = function(val) {
            return val.replace(/\D/g, '').length === 11 ? '(00) 00000-0000' : '(00) 0000-00009';
        };
        var options = {
            onKeyPress: function(val, e, field, options) {
                field.mask(behavior.apply({}, arguments), options);
            }
        };
        $('.telefone').mask(behavior, options);

        // Ao clicar em "Salvar Alterações"
        $('#btnConfirmar').on('click', function(e){
            e.preventDefault();

            $('#confNomePai').text($("input[name='nomePai']").val());
            $('#confTelefonePai').text($("input[name='telefonePai']").val());
            $('#confNomeMae').text($("input[name='nomeMae']").val());
            $('#confTelefoneMae').text($("input[name='telefoneMae']").val());
            $('#confTelefoneRespLegal').text($("input[name='telefoneRespLegal']").val());

            $('#confirmModal').modal('show');
        });

        // Envia o formulário ao confirmar
        $('#confirmarEnvio').on('click', function(){
            $('form').submit();
        });

    });
    </script>

</body>
</html>
