<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Aprovação de Requisição</title>
    <!-- Bootstrap CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">

    <style>
        /* Tema verde militar */
        body {
            background-color: #f8f9fa;
        }

        h1 {
            color: #4b5320; /* Verde militar */
        }

        label {
            font-weight: bold;
            color: #4b5320; /* Verde militar */
        }

        .form-select, .form-control {
            border: 1px solid #4b5320; /* Verde militar */
        }

        .form-select:focus, .form-control:focus {
            border-color: #394018; /* Verde militar mais escuro */
            box-shadow: 0 0 5px #394018;
        }

        .btn-primary {
            background-color: #4b5320; /* Verde militar */
            border: none;
        }

        .btn-primary:hover {
            background-color: #394018; /* Verde militar mais escuro */
        }
    </style>
</head>
<body>
    <div class="container mt-5">
        <h1 class="mb-4">Aprovação de Requisição</h1>
        <form action="process.php" method="POST">
            <div class="row">
                <!-- Primeiro campo select -->
                <div class="col-md-4">
                    <label for="categoria" class="form-label">Status da Requisição</label>
                    <select id="categoria" name="status" class="form-select" required style="text-transform:uppercase;">
                        <option value="">Selecione uma opção</option>
                        <option value="Aguardando">Aguardando</option>
                        <option value="Aprovado">Aprovado</option>
                        <option value="Desaprovado">Desaprovado</option>
                    </select>
                </div>

                <!-- Segundo campo select -->
                <div class="col-md-4">
                    <label for="subcategoria" class="form-label">Aprovado/Negado por</label>
                    <select id="subcategoria" name="autorizado_por" class="form-select" required style="text-transform:uppercase;">
                        <option value="">Selecione uma opção</option>
                        <option value="Aguardando">Aguardando</option>
                        <option value="Gustavo Ávila">Gustavo Ávila</option>
                        <option value="Leandro Ávila">Leandro Ávila</option>
                        <option value="Guilherme Talma">Guilherme Talma</option>
                    </select>
                </div>

                <!-- Campo de input -->
                <div class="col-md-4">
                    <label for="id" class="form-label">Requisição</label>
                    <input type="text" id="id" name="id" class="form-control" placeholder="Digite o código da requisição" style="text-transform:uppercase;" required>
                </div>
            </div>

            <!-- Botão de envio -->
            <div class="mt-4">
                <button type="submit" class="btn btn-primary">REGISTRAR</button>
            </div>
        </form>
    </div>

    <!-- Bootstrap JS -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
