<?php
$codigo = $_GET['codigo'];
$titulo = $_GET['requisicao'];
?>

<!DOCTYPE html>
<html lang="pt-br">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Requisição de Equipamentos</title>
    <!-- Link para o CSS do Bootstrap -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha3/dist/css/bootstrap.min.css" rel="stylesheet">
    <!-- Link para a fonte Google Sans -->
    <link href="https://fonts.googleapis.com/css2?family=Google+Sans:wght@400;500;700&display=swap" rel="stylesheet">

    <style>
        /* Aplicação da fonte Google Sans e tamanho da fonte */
        body, table, button, h6 {
            font-family: 'Google Sans', sans-serif;
            font-size: 14px;
        }

        @media (max-width: 600px) {
            td[data-label]::before {
                content: attr(data-label);
                font-weight: bold;
                display: block;
            }
        }

        /* Tabela estilizada com listras em verde pastel */
        .table-striped tbody tr:nth-of-type(odd) {
            background-color: #e9f7e9; /* Verde pastel */
        }

        .table-striped tbody tr:nth-of-type(even) {
            background-color: #ffffff; /* Branco */
        }

        /* Cabeçalho em verde militar */
        .table-header-green {
            background-color: #4b5320; /* Verde militar */
            color: #fff;
        }

        .text-right {
            text-align: right;
        }

        .button {
            margin: 0 15px;
        }

        /* Estilo dos botões */
        .btn-military-green {
            background-color: #4b5320; /* Verde militar */
            color: #fff;
            border: none;
        }

        .btn-military-green:hover {
            background-color: #394018; /* Verde militar mais escuro */
            color: #fff;
        }
    </style>
</head>
<body>

<div class="container mt-4">
    <h6 class="mb-3 text-uppercase">Nº Requisição: <?php echo $codigo; ?></h6>
    <h6 class="mb-3 text-uppercase">Requisição: <?php echo $titulo; ?></h6>

    <table class="table table-striped table-bordered table-sm border-dark">
        <thead class="table-header-green">
            <tr>
                <th class="text-uppercase">qd</th>
                <th class="text-uppercase">descrição</th>
                <th class="text-uppercase">valor unitário (R$)</th>
                <th class="text-uppercase">valor total (R$)</th>
            </tr>
        </thead>
        <tbody>
            <?php
            // Conexão com o banco de dados
            $servername = "localhost";
            $username = "root";
            $password = "";
            $dbname = "pedidos_equipamentos";

            // Criando conexão
            $conn = new mysqli($servername, $username, $password, $dbname);

            // Checando conexão
            if ($conn->connect_error) {
                die("Conexão falhou: " . $conn->connect_error);
            }

            // Consulta SQL
            $sql = "SELECT pedidos.codigo, pedidos.quantidade, pedidos.descricao, pedidos.valor_unitario, pedidos.data_pedido, frete.valor_frete, requisicao.titulo_requisicao, requisicao.data_requisicao 
                    FROM pedidos 
                    JOIN frete ON pedidos.codigo = frete.codigo 
                    JOIN requisicao ON pedidos.codigo = requisicao.codigo 
                    WHERE pedidos.codigo = '$codigo'";

            // Inicializa o valor total
            $valor_total = 0;
            $result = $conn->query($sql); 
            // Verifica se retornou resultados
            if ($result->num_rows > 0) {
                // Exibindo cada linha de dados
                while($row = $result->fetch_assoc()) {
                    $valor_frete = $row['valor_frete'];
                    $valor_total_itens = ($row['quantidade'] * $row['valor_unitario']);
    
                    // Soma o valor total de cada item ao valor total geral
                    $valor_total += $valor_total_itens;
                    echo "<tr>";
                    echo "<td class='text-uppercase' data-label=''>" . $row['quantidade'] . "</td>";
                    echo "<td class='text-uppercase' data-label=''>" . $row['descricao'] . "</td>";
                    echo "<td class='text-uppercase' data-label=''>R$ " . number_format($row['valor_unitario'], 2, ',', '.') . "</td>";
                    echo "<td class='text-uppercase' data-label=''>R$ " . number_format($valor_total_itens, 2, ',', '.') . "</td>";
                    echo "</tr>";
                }
            } else {
                echo "<tr><td colspan='4'>Nenhum resultado encontrado</td></tr>";
            }

            // Fechando conexão
            $conn->close();
            $valor_total_frete = $valor_total + $valor_frete;
            ?>

            <!-- Linha para o valor do frete -->
            <tr>
                <td colspan="3" class="text-uppercase text-right">Valor Frete (R$):</td>
                <td>R$ <?php echo $valor_frete; ?></td>
            </tr>
            <!-- Linha para o valor total -->
            <tr>
                <td colspan="3" class="text-uppercase text-right">Valor Total (R$):</td>
                <td>R$ <?php echo number_format($valor_total_frete, 2, ',', '.'); ?></td>
            </tr>
        </tbody>
    </table>

    <!-- Botões fora da tabela -->
    <a href="index.php"><button type="button" class="btn btn-military-green">Voltar</button></a>
    <a href="../../update.php"><button type="button" class="btn btn-military-green button">Aprovar</button></a>
</div>

<!-- Link para o JS do Bootstrap e dependências -->
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha3/dist/js/bootstrap.bundle.min.js"></script>

</body>
</html>
