<!DOCTYPE html>
<html lang="pt-br">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Atualizar Pedido</title>
    <!-- Bootstrap CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha1/dist/css/bootstrap.min.css" rel="stylesheet">
    <script>
        // Função para adicionar novos campos
        function adicionarCampos(quantidade = '', descricao = '', valor_unitario = '') {
            const container = document.getElementById('campo-container');

            // Cria um novo conjunto de campos para quantidade, descrição e valor unitário
            const novoGrupo = document.createElement('div');
            novoGrupo.classList.add('row', 'mb-3');

            // Cria os campos de Quantidade
            const quantidadeDiv = document.createElement('div');
            quantidadeDiv.classList.add('col');
            quantidadeDiv.innerHTML = `
                <label for="quantidade[]" class="form-label">Quantidade</label>
                <input type="number" class="form-control" name="quantidade[]" value="${quantidade}" required>
            `;

            // Cria os campos de Descrição
            const descricaoDiv = document.createElement('div');
            descricaoDiv.classList.add('col');
            descricaoDiv.innerHTML = `
                <label for="descricao[]" class="form-label">Descrição</label>
                <input type="text" class="form-control" name="descricao[]" value="${descricao}" required>
            `;

            // Cria os campos de Valor Unitário
            const valorUnitarioDiv = document.createElement('div');
            valorUnitarioDiv.classList.add('col');
            valorUnitarioDiv.innerHTML = `
                <label for="valor_unitario[]" class="form-label">Valor Unitário</label>
                <input type="text" class="form-control" name="valor_unitario[]" value="${valor_unitario}" required>
            `;

            // Botão de Remover
            const removerDiv = document.createElement('div');
            removerDiv.classList.add('col-auto', 'align-self-end');
            removerDiv.innerHTML = `
                <button type="button" class="btn btn-danger" onclick="removerCampo(this)">Remover</button>
            `;

            // Adiciona os campos criados ao novo grupo
            novoGrupo.appendChild(quantidadeDiv);
            novoGrupo.appendChild(descricaoDiv);
            novoGrupo.appendChild(valorUnitarioDiv);
            novoGrupo.appendChild(removerDiv);

            // Adiciona o novo grupo ao container
            container.appendChild(novoGrupo);
        }

        // Função para remover o campo
        function removerCampo(elemento) {
            const campoParaRemover = elemento.parentNode.parentNode; // Acessa o grupo pai
            campoParaRemover.remove(); // Remove o grupo de campos
        }

        // Carregar os dados existentes para edição (você pode definir isso no backend)
        function carregarDadosExistentes(dados) {
            dados.forEach(item => {
                adicionarCampos(item.quantidade, item.descricao, item.valor_unitario);
            });
        }

        // Exemplo de dados carregados (simulação)
        document.addEventListener("DOMContentLoaded", function() {
            const dadosExistentes = [
                {quantidade: 5, descricao: 'Produto A', valor_unitario: 15.00},
                {quantidade: 3, descricao: 'Produto B', valor_unitario: 30.00}
            ];
            carregarDadosExistentes(dadosExistentes);
        });
    </script>
</head>
<body>
    <div class="container mt-5">
        <h1 class="text-center">Atualizar Pedido</h1>
        <form method="POST" action="update.php">
            <!-- Container onde os campos serão adicionados -->
            <div id="campo-container">
                <!-- Os campos existentes serão carregados aqui via JavaScript -->
            </div>

            <!-- Botão para adicionar mais campos -->
            <button type="button" class="btn btn-secondary mb-3" onclick="adicionarCampos()">Adicionar Mais</button>

            <!-- Campos fixos do formulário -->
            <div class="mb-3">
                <label for="data_pedido" class="form-label">Data do Pedido</label>
                <input type="date" class="form-control" id="data_pedido" name="data_pedido" value="2023-09-01" required>
            </div>
            <div class="mb-3">
                <label for="codigo" class="form-label">Código</label>
                <input type="text" class="form-control" id="codigo" name="codigo" value="XYZ123" required>
            </div>

            <button type="submit" class="btn btn-primary">Atualizar Pedido</button>
            <button type="submit" formaction="delete.php" class="btn btn-danger">Remover Pedido</button>
        </form>
    </div>

    <!-- Bootstrap JS (opcional, para funcionalidades extras) -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha1/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
