<?php
// Gera um número randomico entre 1000 e 9999
$numero_aleatorio = rand(1000, 9999);
?>

<!DOCTYPE html>
<html lang="pt-br">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Nova Requisição</title>
    <!-- Bootstrap CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha1/dist/css/bootstrap.min.css" rel="stylesheet">
    <!-- jQuery -->
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <!-- jQuery Mask Plugin -->
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery.mask/1.14.16/jquery.mask.min.js"></script>

    <script>
        // Função para adicionar novos campos
        function adicionarCampos() {
            const container = document.getElementById('campo-container');

            const novoGrupo = document.createElement('div');
            novoGrupo.classList.add('row', 'mb-3');

            // Campo de Quantidade
            novoGrupo.innerHTML = `
                <div class="col">
                    <label for="quantidade[]" class="form-label">Quantidade</label>
                    <input type="number" class="form-control" name="quantidade[]" required>
                </div>
                <div class="col">
                    <label for="descricao[]" class="form-label">Descrição</label>
                    <input type="text" class="form-control" name="descricao[]" required>
                </div>
                <div class="col">
                    <label for="valor_unitario[]" class="form-label">Valor Unitário</label>
                    <input type="text" class="form-control valor-unitario" name="valor_unitario[]" required>
                </div>
                <div class="col-auto align-self-end">
                    <button type="button" class="btn btn-danger" onclick="removerCampo(this)">Remover</button>
                </div>
            `;
            container.appendChild(novoGrupo);
            aplicarMascara();
        }

        // Função para remover o campo
        function removerCampo(elemento) {
            elemento.parentElement.parentElement.remove();
        }

        // Função para aplicar máscara de moeda
        function aplicarMascara() {
            $('.valor-unitario').mask('000.000.000.000.000,00', {reverse: true});
        }

        // Remove máscaras antes de enviar o formulário
        function removerMascaras() {
            $('.valor-unitario').each(function() {
                const valor = $(this).val().replace(/\./g, '').replace(/,/g, '.'); // Remove pontos e substitui vírgula por ponto
                $(this).val(valor);
            });
        }

        $(document).ready(function() {
            aplicarMascara();
            $('form').on('submit', function() {
                removerMascaras();
            });
        });
    </script>
</head>
<body>
    <div class="container mt-5">
        <h1 class="text-center">Nova Requisição</h1><br>

        <form method="POST" action="store.php">
            <!-- Campo de Título -->
            <div class="mb-3">
                <label for="titulo" class="form-label">Título</label>
                <input type="text" class="form-control" id="titulo" name="titulo" required>
            </div>

            <!-- Container onde os campos serão adicionados -->
            <div id="campo-container">
                <div class="row mb-3">
                    <div class="col">
                        <label for="quantidade[]" class="form-label">Quantidade</label>
                        <input type="number" class="form-control" name="quantidade[]" required>
                    </div>
                    <div class="col">
                        <label for="descricao[]" class="form-label">Descrição</label>
                        <input type="text" class="form-control" name="descricao[]" required>
                    </div>
                    <div class="col">
                        <label for="valor_unitario[]" class="form-label">Valor Unitário</label>
                        <input type="text" class="form-control valor-unitario" name="valor_unitario[]" required>
                    </div>
                    <div class="col-auto align-self-end">
                        <button type="button" class="btn btn-danger" onclick="removerCampo(this)">Remover</button>
                    </div>
                </div>
            </div>

            <!-- Botão para adicionar mais campos -->
            <button type="button" class="btn btn-secondary mb-3" onclick="adicionarCampos()">Adicionar Mais</button>

            <!-- Campo Data, Valor Frete e Código -->
            <div class="row mb-3">
                <div class="col">
                    <label for="data_pedido" class="form-label">Data do Pedido</label>
                    <?php 
                    date_default_timezone_set('America/Sao_Paulo');
                    $date = date('d/m/Y H:i:s');
                    ?>
                    <input type="text" class="form-control" id="data_pedido" name="data_pedido" value="<?php echo $date; ?>" readonly>
                </div>
                <div class="col">
                    <label for="valor_frete" class="form-label">Valor Frete</label>
                    <input type="text" class="form-control valor-unitario" id="valor_frete" name="valor_frete" required>
                </div>
                <div class="col">
                    <label for="codigo" class="form-label">Código</label>
                    <input type="text" class="form-control" id="codigo" name="codigo" value="<?php echo $numero_aleatorio; ?>" readonly>
                </div>
            </div>

            <button type="submit" class="btn btn-primary">Salvar Requisição</button>
            <a href="index.php" class="btn btn-secondary">Voltar</a>
        </form>
    </div><br><br>

    <!-- Bootstrap JS -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha1/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
