<?php
include 'db.php';

date_default_timezone_set('America/Sao_Paulo');
$date = date('Y/m/d H:i:s');

// Captura os dados dos arrays
$quantidades = $_POST['quantidade'];
$descricoes = $_POST['descricao'];
$valores_unitarios = $_POST['valor_unitario'];
$data_pedido = $date;
$codigo = $_POST['codigo'];
$valor_frete = $_POST['valor_frete'];
$titulo_requisicao = $_POST['titulo'];

// Verifica se os arrays têm o mesmo tamanho
if (count($quantidades) === count($descricoes) && count($descricoes) === count($valores_unitarios)) {
    // Inicia uma transação para garantir que os INSERTs sejam realizados juntos
    $conn->begin_transaction(MYSQLI_TRANS_START_READ_WRITE);

    try {
        // Insere os dados na tabela pedidos
        for ($i = 0; $i < count($quantidades); $i++) {
            $quantidade = intval($quantidades[$i]);
            $descricao = $conn->real_escape_string($descricoes[$i]);
            
            // Remove separadores de milhares e garante o formato decimal
            $valor_unitario = number_format((float)str_replace(',', '', $valores_unitarios[$i]), 2, '.', '');

            $sql_pedidos = "INSERT INTO pedidos (quantidade, descricao, valor_unitario, data_pedido, codigo) 
                            VALUES ('$quantidade', '$descricao', '$valor_unitario', '$data_pedido', '$codigo')";

            if ($conn->query($sql_pedidos) !== TRUE) {
                throw new Exception("Erro ao inserir na tabela pedidos: " . $conn->error);
            }
        }

        // Insere o código e o valor do frete na tabela frete
        $valor_frete_formatado = number_format((float)str_replace(',', '', $valor_frete), 2, '.', '');
        $sql_frete = "INSERT INTO frete (codigo, valor_frete) VALUES ('$codigo', '$valor_frete_formatado')";

        if ($conn->query($sql_frete) !== TRUE) {
            throw new Exception("Erro ao inserir na tabela frete: " . $conn->error);
        }
        
        // Insere o código e o título da requisição na tabela requisicao
        $titulo_requisicao = $conn->real_escape_string($titulo_requisicao);
        $sql_requisicao = "INSERT INTO requisicao (codigo, titulo_requisicao, data_requisicao) VALUES ('$codigo', '$titulo_requisicao', '$data_pedido')";

        if ($conn->query($sql_requisicao) !== TRUE) {
            throw new Exception("Erro ao inserir na tabela requisicao: " . $conn->error);
        }

        // Se tudo estiver correto, confirma a transação
        $conn->commit();
        header("Location: index.php");
    } catch (Exception $e) {
        // Se algo der errado, desfaz a transação
        $conn->rollback();
        echo "Erro: " . $e->getMessage();
    }
} else {
    echo "Erro: Arrays de dados de diferentes tamanhos.";
}

$conn->close();
?>
