<?php
// Configurações do banco de dados
$host = "localhost"; // Host do banco de dados
$dbname = "pedidos_equipamentos"; // Nome do banco de dados
$username = "root"; // Usuário do banco de dados
$password = ""; // Senha do banco de dados

try {
    // Conexão com o banco de dados
    $pdo = new PDO("mysql:host=$host;dbname=$dbname", $username, $password);
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

    // Verifica se o formulário foi enviado
    if ($_SERVER['REQUEST_METHOD'] === 'POST') {
        // Obtém os dados do formulário
        $id = $_POST['id'];
        $status = $_POST['status'];
        $autorizado_por = $_POST['autorizado_por'];

        // Valida se os campos estão preenchidos
        if (!empty($id) && !empty($status) && !empty($autorizado_por)) {
            // Consulta SQL para atualizar o registro
            $sql = "UPDATE requisicao SET status = :status, autorizado_por = :autorizado_por WHERE codigo = :id";

            // Prepara a consulta
            $stmt = $pdo->prepare($sql);

            // Associa os valores aos parâmetros
            $stmt->bindParam(':id', $id, PDO::PARAM_INT);
            $stmt->bindParam(':status', $status, PDO::PARAM_STR);
            $stmt->bindParam(':autorizado_por', $autorizado_por, PDO::PARAM_STR);

            // Executa a consulta
            if ($stmt->execute()) {
                // Exibe um alerta e redireciona para ../pedidos/pedidos
                echo "<script>
                    alert('Registro atualizado com sucesso!');
                    window.location.href = '../pedidos/pedidos';
                </script>";
                exit(); // Encerra o script após o redirecionamento
            } else {
                echo "<script>alert('Erro ao atualizar o registro.');</script>";
            }
        } else {
            echo "<script>alert('Todos os campos são obrigatórios.');</script>";
        }
    }
} catch (PDOException $e) {
    // Trata erros de conexão
    echo "<script>alert('Erro na conexão: " . addslashes($e->getMessage()) . "');</script>";
}
?>
