<?php
$idTurma = $_GET['id_turma'];
$idDisciplina = $_GET['id_disciplina'];
$notaRecebida = $_GET['identificadorTarefa']; // Ex: NT1, NT2, ..., NT30

// Valida se a entrada está no formato NT1 até NT30
if (!preg_match('/^NT([1-9]|[1-2][0-9]|30)$/', $notaRecebida)) {
    die("Identificador de tarefa inválido.");
}

// Converte NTx para Tx (removendo o N)
$colunaNota = 't' . substr($notaRecebida, 2);

// Conexão com banco
$pdo = new PDO('mysql:host=localhost;dbname=kaltekgo_avila', 'kaltekgo_admin', 'kaltek@2024');

// Monta a consulta SQL
$sql = "SELECT *
        FROM nota_tarefas_entregues_fundamental1
        WHERE $colunaNota IN ('F', 'N') AND id_turma = :idTurma AND id_disciplina = :idDisciplina";

$stmt = $pdo->prepare($sql);
$stmt->execute([
    ':idTurma' => $idTurma,
    ':idDisciplina' => $idDisciplina
]);

$alunos = $stmt->fetchAll(PDO::FETCH_ASSOC);
?>

<!DOCTYPE html>
<html>
<head>
    <title>Tabela de Notas</title>
    <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/3.4.1/css/bootstrap.min.css">
  <style>
    body {
      font-family: Arial, sans-serif;
      background-color: #ffffff;
      margin: 20px;
      color: #000000;
    }

    .topo-logo {
      display: flex;
      align-items: flex-start;
      gap: 20px;
      margin-bottom: 20px;
    }

    .topo-logo img {
      max-width: 200px;
      height: auto;
      position: absolute;
      margin-left: 1100px;
    }

    .info-topo {
      flex: 1;
    }

    .container-fluid {
      width: 100%;
    }

    h4, h5 {
      margin: 0 0 10px;
    }

    .btn-cadastrar, .filtro-btns {
      margin-left: 15px;
      margin-bottom: 10px;
    }

    .table-responsive-custom {
      overflow-x: auto;
      margin: 0 15px 20px 15px;
      display: block;
    }

    table {
      white-space: nowrap;
      width: 100%;
      border-collapse: collapse;
      background-color: #ffffff;
      box-shadow: 0 0 10px rgba(0,0,0,0.1);
      text-transform: uppercase;
      min-width: 700px;
    }

    th, td {
      padding: 12px 15px;
      text-align: left;
      font-size: 12px;
      border: 1px solid #000;
      vertical-align: middle !important;
    }

    th {
      background-color: #000;
      color: #fff;
    }

    tr:nth-child(even) {
      background-color: #f4f4f4;
    }

    tr:hover {
      background-color: #e0e0e0;
    }

    @media (max-width: 768px) {
      .btn-cadastrar, .filtro-btns .btn {
        width: 100% !important;
        margin: 10px auto;
        font-size: 16px;
        height: 45px;
        padding: 10px 12px;
      }

      .form-group label,
      .form-control {
        font-size: 14px;
      }

      .form-control,
      input[type="text"],
      select {
        height: 40px;
      }

      .table-responsive-custom {
        overflow-x: auto;
        display: block;
      }

      table {
        width: auto;
      }

      .table th, .table td {
        min-width: 125px;
        font-size: 14px;
        padding: 8px 10px;
      }

      h4 {
        text-align: center;
      }
    }
  </style>
</head>
<body>
    <h2 style="text-align:center;">Alunos com F ou N em <?= htmlspecialchars($colunaNota) ?></h2>
    <table>
        <tr>
            <th>Matrícula</th>
            <th>Nome</th>
            <th>N<?= htmlspecialchars($colunaNota) ?></th>
        </tr>
        <?php foreach ($alunos as $aluno): ?>
            <tr>
                <td><?= htmlspecialchars($aluno['matricula']) ?></td>
                <td><?= htmlspecialchars($aluno['nome']) ?></td>
                <td><?= htmlspecialchars($aluno[$colunaNota]) ?></td>
            </tr>
        <?php endforeach; ?>
    </table>
</body>
</html>
